<?php
class Security {

    /* =========================
       SANITASI INPUT
    ========================== */
    public static function clean($data) {
        if (is_array($data)) {
            return array_map([self::class, 'clean'], $data);
        }
        return htmlspecialchars(strip_tags(trim($data)), ENT_QUOTES, 'UTF-8');
    }

    /* =========================
       HASH PASSWORD
    ========================== */
    public static function hashPassword($password) {
        return password_hash($password, PASSWORD_BCRYPT);
    }

    /* =========================
       VERIFIKASI PASSWORD
    ========================== */
    public static function verifyPassword($password, $hash) {
        return password_verify($password, $hash);
    }

    /* =========================
       CSRF TOKEN
    ========================== */
    public static function generateCSRF() {
        if (empty($_SESSION['csrf_token'])) {
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
        }
        return $_SESSION['csrf_token'];
    }

    public static function checkCSRF($token) {
        if (!isset($_SESSION['csrf_token']) || $token !== $_SESSION['csrf_token']) {
            die('CSRF Token tidak valid');
        }
    }

    /* =========================
       VALIDASI ANGKA
    ========================== */
    public static function number($value) {
        return filter_var($value, FILTER_VALIDATE_INT);
    }

    /* =========================
       VALIDASI EMAIL
    ========================== */
    public static function email($email) {
        return filter_var($email, FILTER_VALIDATE_EMAIL);
    }

    /* =========================
       LOG ERROR
    ========================== */
    public static function log($message) {
        $file = __DIR__ . '/../logs/error.log';
        $date = date('Y-m-d H:i:s');
        file_put_contents($file, "[$date] $message\n", FILE_APPEND);
    }
}
